---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：19-Video brightness

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **vo_set_brightness()の全呼び出し元の網羅性**：すべてのsyscltハンドラやイベントハンドラからの呼び出しを完全に確認できていない

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/acpica/acpi_video.c` 1174-1189行目 - vo_set_brightness()関数の実装
- E-02: `sys/dev/acpica/acpi_video.c` 1188行目 - devctl_notify()呼び出し
- E-03: `sys/dev/acpica/acpi_video.c` 1180行目 - acpi_SetInteger("_BCM", level)
- E-04: `sys/dev/acpica/acpi_video.c` 1181-1183行目 - ACPI_FAILURE時のエラー処理
- E-05: `sys/dev/acpica/acpi_video.c` 1185行目 - vo->vo_level更新
- E-06: `sys/dev/acpica/acpi_video.c` 1187行目 - notify_buf生成（"notify=%d"）
- E-07: `sys/dev/acpica/acpi_video.c` 52-72行目 - acpi_video_output構造体定義
- E-08: `sys/dev/acpica/acpi_video.c` 1179行目 - ACPI_SERIAL_ASSERT

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("ACPI", "Video", "brightness", notify_buf)として通知される | E-02 | ○ |
| C-02 | acpi_SetInteger()で_BCMメソッドを呼び出す | E-03 | ○ |
| C-03 | _BCM失敗時もdevctl通知は発行される | E-01, E-04 | ○ |
| C-04 | _BCM成功時のみvo_levelが更新される | E-05 | ○ |
| C-05 | notify_bufは"notify=%d"フォーマット | E-06 | ○ |
| C-06 | vo_set_brightness()は1174行目に定義されている | E-01 | ○ |
| C-07 | devctl_notifyは1188行目で呼び出される | E-02 | ○ |
| C-08 | ACPI_SERIAL_ASSERTでシリアライゼーションが保証される | E-08 | ○ |
| C-09 | acpi_video_output構造体にvo_level、vo_hasbqcが含まれる | E-07 | ○ |
| C-10 | 輝度レベルは0-100の範囲 | E-07 | ○ |
| C-11 | sysctl、電源プロファイル変更、ACPIイベントが呼び出し元 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11: vo_set_brightness()の呼び出し元について、acpi_video.c内の関数を直接確認する必要がある
  - 候補：acpi_video_vo_active_sysctl() / acpi_video_power_profile() / acpi_video_notify_handler()

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - devctl_notifyの引数とフォーマットはコードから直接確認済み
- 0: 低リスク - _BCM失敗時も通知が発行されることはコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] vo_set_brightness()の呼び出し元が網羅的か確認
- [ ] 輝度レベルの範囲（0-100）が正確か確認
